#version 130
#extension GL_EXT_gpu_shader4 : enable
// the version and open GL extension
// should be the first line of the shader
/////////////////////////////////////////////////////////////////////////////////
//  Cave testMod01.fsh    by    Miolith  
//https://www.shadertoy.com/view/t3s3R8
//Licence : Creative Commons Attribution-ShareAlike 4.0
//http://creativecommons.org/licences/by-sa/4.0
// Adapted, trivialy, for use in VGHD player
/////////////////////////////////////////////
uniform float u_Elapsed;    // The elapsed time in seconds
uniform vec2  u_WindowSize; // Window dimensions in pixels
uniform int   iFrame;

#define iTime u_Elapsed*0.314159  //*0.1666
#define iResolution u_WindowSize

//#define mouse AUTO_MOUSE
//#define MOUSE_SPEED vec2(vec2(0.5,0.577777) * 0.25)
//#define MOUSE_POS   vec2((1.0+cos(iTime*MOUSE_SPEED))*u_WindowSize/2.0)
//#define MOUSE_PRESS vec2(0.0,0.0)
//#define AUTO_MOUSE  vec4( MOUSE_POS, MOUSE_PRESS )
//#define RIGID_SCROLL
// alternatively use static mouse definition
#define iMouse vec4(0.0,0.0, 0.0,0.0)
//#define iMouse vec4(512,256,180,120)
uniform sampler2D texture0;
uniform sampler2D texture1;
uniform sampler2D texture2;
uniform sampler2D texture3;
vec4 texture2D_Fract(sampler2D sampler,vec2 P) {return texture2D(sampler,fract(P));}
vec4 texture2D_Fract(sampler2D sampler,vec2 P, float Bias) {return texture2D(sampler,fract(P),Bias);}
#define texture2D texture2D_Fract

const float PI = 3.14159265;

const int NO_OBJECT_FOUND = -1;
const int LIGHT_ORB_INDEX = 0;
const int CAVE_INDEX = 1;
const int WATER_INDEX = 2;

//start common //
struct Obj
{
    int index;
    float dist;
    vec3 pos;
};


struct rayPayload
{
    int obj_index;
    vec3 pos;
    float t;
};


mat2x2 rot(float angle)
{
    float c = cos(angle), s = sin(angle);
    return mat2(
        c, -s,
        s, c
    );
}


float smin( float a, float b, float k)
{
    float h = clamp( 0.5+0.5*(b-a)/k, 0.0, 1.0 );
    return mix( b, a, h ) - k*h*(1.0-h);
}


Obj closestObject(in Obj obj1, in Obj obj2)
{    
    if (obj1.dist < obj2.dist)
        return obj1;
    return obj2;
}
//end common //
// ************** SCENE ************** //

vec3 lightOrbPos() { return 4.0*vec3(cos(iTime*0.5), 0.0, sin(iTime*0.5)); }

Obj lightOrb(vec3 pos)
{
    float dist = length(pos - lightOrbPos()) - 0.5;
    return Obj(LIGHT_ORB_INDEX, dist, pos);
}

Obj cave(vec3 pos)
{
    float dist = length(vec2(length(pos.xz) - 4.0, pos.y)) - 3.0;
    dist = abs(dist) - 0.35;
    
    vec3 p;
    
    p = pos * 8.0;
    dist -= sin(p.x)*sin(p.y)*sin(p.z) / 8.0;
    
    p = pos * 4.0;
    dist -= sin(p.x)*sin(p.y)*sin(p.z) / 4.0;
    
    p = pos * 20.0;
    dist -= sin(p.x)*sin(p.y)*sin(p.z) / 30.0;
    
    p = pos;
    p.y = abs(p.y) - 4.2;
    
    const float rep = 3.5;
    vec2 id = round(p.xz/rep)*rep;
    p.xz -= id;
    
    p.y = max(abs(p.y) - 3.0, 0.0);
    float d = length(p) - 0.02;
    
    dist = smin(dist, d, 1.5);
    
    return Obj(CAVE_INDEX, dist*0.5, pos);
}

Obj water(vec3 pos)
{
    float dist = pos.y+2.1 - sin(pos.x*2.0-iTime*1.5)*sin(pos.z*4.0+iTime)*0.1;
    dist -= cos(pos.x*4.0+iTime*2.5)*sin(pos.z*7.0-iTime*1.5)*0.05;
    return Obj(WATER_INDEX, dist, pos);
}



Obj scene(vec3 pos, bool ignoreWater)
{
    Obj objects;
    objects = cave(pos);
    objects = closestObject(objects, lightOrb(pos));
    
    if (!ignoreWater)
        objects = closestObject(objects, water(pos));

    return objects;
}

Obj scene(vec3 pos) { return scene(pos, false); }


// ************** END SCENE ************** //



// ************** RAY MARCH ************** //


vec3 calcNormal( in vec3 pos )
{
    const float h = 0.0001;
    vec3 n = vec3(0.0);
    for( int i=(min(iFrame,0)); i<4; i++ )
    {
        vec3 e = 0.5773*(2.0*vec3((((i+3)>>1)&1),((i>>1)&1),(i&1))-1.0);
        n += e*scene(pos+e*h).dist;
    }
    return normalize(n);
}


rayPayload rayMarch(vec3 orig, vec3 dir, float max_dist, int max_iter, bool ignoreWater)
{    
    vec3 ray_pos;
    float t = 0.0;
    Obj object;
    
    for (int i = 0; i < max_iter; i++)
    {
        ray_pos = orig + dir * t;
        object = scene(ray_pos, ignoreWater);
        
        if (t > max_dist)
            return rayPayload(NO_OBJECT_FOUND, vec3(0), 0.);
        
        if(object.dist < 0.001) break;
        
        t += object.dist;
    }
    
    return rayPayload(object.index, object.pos, t);
}


// ************** END RAY MARCH ************** //



// ************** COLORIZE ************** //

const vec3 lightColor = vec3(1, 0.453, 0.155);

vec3 lightOrbColor(vec3 pos, vec3 n, vec3 ray_dir)
{
    float fresnel = pow(max(dot(n,-ray_dir), 0.0), 3.0);
    return mix(lightColor, vec3(1,1,1), fresnel);
}

vec3 caveColor(vec3 pos, vec3 n, vec3 ray_dir)
{
    float angle = atan(pos.z, pos.x) / (2.*PI);
    angle = 4.0 * (angle < 0. ? angle+1.0 : angle);

    vec3 albedo = textureLod(
        texture0,
        vec2(length(pos), angle),
        0.5
    ).rgb;
    
    vec3 dir = lightOrbPos() - pos;
    
    vec3 ndir = normalize(dir);
    
    float diffuse = max(dot(ndir, n), 0.0) / (0.5*dot(dir,dir)) + 0.02;
    
    vec3 color = diffuse * albedo * lightColor;
        
    return color;
}

vec3 waterColor(vec3 pos, vec3 n, vec3 ray_dir)
{
    vec3 dir = reflect(ray_dir, n);
    vec3 orig = pos;

    
   rayPayload obj = rayMarch(orig, dir, 50.0, 150, true);

    vec3 col;
    if (obj.obj_index != NO_OBJECT_FOUND)
    {
        vec3 ray_pos = orig + dir * obj.t;
    
        vec3 n = calcNormal(ray_pos);

        switch(obj.obj_index)
        {
            case LIGHT_ORB_INDEX: col = lightOrbColor(obj.pos, n, dir); break;
            case CAVE_INDEX: col = caveColor(obj.pos, n, dir); break;

            default: col = vec3(1.0); break;
        }
    }

    return col*0.5;
}

vec3 colorize(rayPayload obj, vec3 ray_orig, vec3 ray_dir)
{
    vec3 col = vec3(0.0);
    vec3 ray_pos = ray_orig + ray_dir * obj.t;
    
    vec3 n = calcNormal(ray_pos);
    
    switch(obj.obj_index)
    {
        case LIGHT_ORB_INDEX: col = lightOrbColor(obj.pos, n, ray_dir); break;
        case CAVE_INDEX: col = caveColor(obj.pos, n, ray_dir); break;
        case WATER_INDEX: col = waterColor(obj.pos, n, ray_dir); break;
        
        default: col = vec3(0.0); break;
    }
    
    return col;
}

// ************** END COLORIZE ************** //

vec3 acesFilm(vec3 x)
{
    return clamp(
          (x * (2.51 * x + 0.03))
        / (x * (2.43 * x + 0.59) + 0.14),
        0.0, 1.0
     );
}

//void mainImage( out vec4 fragColor, in vec2 fragCoord )
///////////////////////////////////////////////////////////////////////////////// 
// need to convert this from a void to a function and call it by adding
// a void main(void) { to the end of the shader
// what type of variable will the function return?, it is a color and needs to be a vec4
// change void to vec4 
//void MainImage(out vec4 fragColor, in vec2 fragCoord) 
vec4 mainImage( out vec4 fragColor, in vec2 fragCoord )
{ 
    vec2 uv = (fragCoord * 2.0 - iResolution.xy) / min(iResolution.y, iResolution.x);
        
    vec3 ray_origin = vec3(0.0, 0.0, -5.0);
    vec3 ray_dir = normalize(vec3(uv, 1.5));
    
    ray_origin.xz *= rot(-iTime*0.33);
    ray_dir.xz *= rot(-iTime*0.33);
    
    rayPayload payload = rayMarch(ray_origin, ray_dir, 50.0, 150, false);

    vec3 col = vec3(0);
    if (payload.obj_index != NO_OBJECT_FOUND)
    {
        col = colorize(payload, ray_origin, ray_dir);
    }
    
    col = acesFilm(col);
    col = pow(col, vec3(0.45));

            
    fragColor = vec4(col, 1.0);
/////////////////////////////////////////////////////////////////////////////////
//the function needs to return a value. 
//it needs to be a vec4
//we will return the varable fragColor 
// usual place for fragColor = vec4( color, 1.0 ); bring the } down below 
return fragColor; 
}

///////////////////////////////////////////////////////////////////////////////// 
void main(void) { // this will be run for every pixel of gl_FragCoord.xy
vec4 vTexCoord = gl_TexCoord[0];
vec4 fragColor = vec4(1.0); // initialize variable fragColor as a vec4 
vec4 cc = mainImage(fragColor, gl_FragCoord.xy); // call function mainImage and assign the return vec4 to cc
gl_FragColor = vec4(cc) * gl_Color; // set the pixel to the value of vec4 cc  and..
gl_FragColor.a = length(gl_FragColor.rgb);
}

// ..uses the values of any Color: or Opacity:
// clauses (and any Animate clauses applied to these properties) 
// appearing in the Sprite, Quad or other node invoking the shader 
// in the .scn file.

